//
//  CRScene.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/24/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRSceneBase.h"

@class CRSceneRenderBreak;
@class CRMipMapper;

extern NSString* const CRSceneScaleKey;
extern NSString* const CRSceneLightIntensityKey;
extern NSString* const CRSceneLightDirectionKey;
extern NSString* const CRSceneLightColorKey;
extern NSString* const CRSceneShadowsModeKey;
extern NSString* const CRSceneShadowColorKey;
extern NSString* const CRSceneShadowSoftnessKey;
extern NSString* const CRScenePlaneAltitudeKey;

extern NSString* const CRSceneCompareModeKey;
extern NSString* const CRSceneCompareAngleKey;
extern NSString* const CRSceneComparePositionKey;

//////////////////////////////////////////////////////////////////////
// Scene
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRSceneCompareNone,
	CRSceneCompareTuple,
} CRSceneCompareMode;

@interface CRScene : CRSceneBase
{
	CGFloat					scale;			// current scale, is used for optimized rendering
	
	BOOL					avoidRender;	// flag signals whether rendering should be avoided while computing output (size measuring, for example)
	CRMipMapper*			mapper;			// source image mip-mapper
	CRSceneRenderBreak*		renderBreak;	// special render break, is used by inplace editor owner to specify specific renderings
}

@property (nonatomic, readonly)	CRMipMapper*		mapper;

@property (nonatomic, assign)	CGFloat				scale;
@property (nonatomic, readonly)	CGFloat				exactScale;
@property (nonatomic, readonly) BOOL				avoidRender;
@property (nonatomic, retain)	CRSceneRenderBreak*	renderBreak;
@property (nonatomic, assign)	BOOL				bestQuality;		// is set to YES for the fullSizedOutput

@property (nonatomic, assign)	CGFloat				lightIntensity;		// params: light intensity
@property (nonatomic, assign)	CGFloat				lightDirection;		// params: light direction
@property (nonatomic, copy)		CIColor*			lightColor;			// params: light color
@property (nonatomic, assign)	NSInteger			shadowsMode;		// params: shadows switch
@property (nonatomic, copy)		CIColor*			shadowColor;		// params: shadows color
@property (nonatomic, assign)	CGFloat				shadowSoftness;		// params: shadow softness
@property (nonatomic, assign)	CGFloat				scenePlaneAltitude;	// params: scene plane alt

@property (nonatomic, readonly)	BOOL				dropShadows;		// shadowsMode wrapper, signals whether there are shadows
@property (nonatomic, readonly)	BOOL				dropInnerShadows;	// shadowsMode wrapper, signals whether there are inner shadows
@property (nonatomic, readonly)	BOOL				dropOuterShadows;	// shadowsMode wrapper, signals whether there are outer shadows

// Zoom special management
- (CGFloat)proposedZoomForRect:(NSRect)rect;
- (CGFloat)proposedZoomForRect:(NSRect)rect spacing:(NSSize)spacing;
- (CIImage *)fullSizedOutput;

// Methods
- (CIImage *)internalProcess:(CIImage *)internalInput transformOnly:(BOOL)onlyTransform;

@end